/*
This file contains the data that encodes the state the board is in
Which includes which chip is currently selected
*/

#ifndef __ltctwrutils_h_
#define __ltctwrutils_h_

#include <mqx.h>
#include <bsp.h>
#include <lwevent.h>
#include <message.h>

#define K60N512_REV_D   1

#define LTC2704_channel 4
#define LTC2600_channel 5
#define LTC2498_channel 6
#define LTC1859_channel 7

//Enum for chip type
typedef enum {
   LTCTWR_2600,
   LTCTWR_2704,
   LTCTWR_2498,
   LTCTWR_1859
} LTCTWR_Chip_t;

//Enum for communication mode
typedef enum 
{
	READ,
	WRITE
} LTCTWR_Mode_t;


//Struct to store the current state of the board
typedef struct {
   uint_8				  numchannels1859;
   uint_8   	                          channels1859[16];
   uint_8				  span1859;
   uint_8				  numchannels2498;
   uint_8	                          channels2498[16];
   uint_8				  setting2498;
   
   uint_8				  channel;
   uint_32                                samplingperiod;
   uint_32                                numsamples;
   uint_8                                 samplesize;
   uint_32				  result;
   uint_32				  temperature;
  // uint_32                                tyear;
  // uint_32                                tmonth;
  // uint_32                                tdate;
   
   char					  destname[25];
   char					  srcname[25];
   
   FILE_PTR				  gpiofd;
   LWGPIO_STRUCT		          decoderpins[4];
   FILE_PTR				  csfd;
   LWGPIO_STRUCT		          cspin[2];
   
   void*                                  resultbuffer;
   LTCTWR_Chip_t                          chip;
   LTCTWR_Mode_t                          mode;
   FILE_PTR                               spifd;
   LWEVENT_STRUCT                         event;

} LTCTWR_PARAMS, * LTCTWR_PARAMS_PTR;


static const char_ptr LTCTWRChipName[] = {"LTC2600", "LTC2704", "LTC2498", "LTC1859"};
static const char_ptr LTCTWRModeName[] = {"Read from ADC", "Write to DAC"};

//static MCF5XXX_QSPI_INIT_STRUCT _bsp_qspi0_init;
extern LTCTWR_PARAMS LTCTWR_Params;


void LTCTWR_InitializeParameters(void);
LTCTWR_PARAMS_PTR LTCTWR_GetParameters(void);
uint_32 str2int(char_ptr ) ;

#endif /* __ltctwrutils_h_ */

